/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.VideoClip;

public class VideoClipControl
extends ClipControl {
    protected VideoClipControl(VideoClip videoClip) {
        super(videoClip);
        this.video.addPropertyChangeListener(this);
    }

    @Override
    public void play() {
        this.video.play();
    }

    @Override
    public void stop() {
        this.video.stop();
    }

    @Override
    public void step() {
        this.video.stop();
        this.setStepNumber(this.stepNumber + 1);
    }

    @Override
    public void back() {
        this.video.stop();
        this.setStepNumber(this.stepNumber - 1);
    }

    @Override
    public void setStepNumber(int n) {
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        n = Math.max(0, n);
        final int n2 = Math.min(this.clip.getStepCount() - 1, n);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = VideoClipControl.this.clip.stepToFrame(n2) + VideoClipControl.this.clip.getFrameShift();
                VideoClipControl.this.video.setFrameNumber(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public int getStepNumber() {
        return this.clip.frameToStep(this.video.getFrameNumber());
    }

    @Override
    public void setRate(double d) {
        if (d == 0.0 || d == this.rate) {
            return;
        }
        this.rate = Math.abs(d);
        this.video.setRate(this.rate);
    }

    @Override
    public double getRate() {
        return this.video.getRate();
    }

    @Override
    public void setLooping(boolean bl) {
        if (bl == this.isLooping()) {
            return;
        }
        this.video.setLooping(bl);
    }

    @Override
    public boolean isLooping() {
        return this.video.isLooping();
    }

    @Override
    public int getFrameNumber() {
        int n = this.video.getFrameNumber() - this.clip.getFrameShift();
        n = Math.max(0, n);
        return n;
    }

    @Override
    public boolean isPlaying() {
        return this.video.isPlaying();
    }

    @Override
    public double getTime() {
        int n = this.video.getFrameNumber();
        return (this.video.getFrameTime(n) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public double getStepTime(int n) {
        int n2 = this.clip.stepToFrame(n);
        return (this.video.getFrameTime(n2) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public void setFrameDuration(double d) {
        if (d == 0.0) {
            return;
        }
        d = Math.abs(d);
        double d2 = this.video.getFrameTime(this.video.getStartFrameNumber());
        double d3 = this.video.getFrameTime(this.video.getEndFrameNumber());
        int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
        if (n != 0) {
            this.timeStretch = d * (double)n / (d3 - d2);
        }
        this.support.firePropertyChange("frameduration", null, new Double(d));
    }

    @Override
    public double getMeanFrameDuration() {
        int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
        if (n != 0) {
            double d = this.video.getFrameTime(this.video.getStartFrameNumber());
            double d2 = this.video.getFrameTime(this.video.getEndFrameNumber());
            return this.timeStretch * (d2 - d) / (double)n;
        }
        return this.timeStretch * this.video.getDuration() / (double)this.video.getFrameCount();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("framenumber")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == this.videoFrameNumber) {
                super.setFrameNumber(n - this.clip.getFrameShift());
                return;
            }
            super.setFrameNumber(n - this.clip.getFrameShift());
            Integer n2 = new Integer(this.stepNumber);
            this.support.firePropertyChange("stepnumber", null, n2);
        } else if (string.equals("playing")) {
            this.support.firePropertyChange(propertyChangeEvent);
        } else if (string.equals("rate") || string.equals("looping")) {
            this.support.firePropertyChange(propertyChangeEvent);
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void dispose() {
        this.video.removePropertyChangeListener(this);
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

