/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPanel;

public abstract class Filter {
    public boolean inspectorVisible;
    public int inspectorX = Integer.MIN_VALUE;
    public int inspectorY;
    private boolean enabled = true;
    private String name;
    protected VideoPanel vidPanel;
    protected PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    protected Action enabledAction;
    protected JCheckBoxMenuItem enabledItem;
    protected JMenuItem deleteItem;
    protected JMenuItem propertiesItem;
    protected boolean hasInspector;
    protected Frame frame;
    protected JButton closeButton;
    protected JButton ableButton;
    protected JButton clearButton;
    protected FilterStack stack;

    protected Filter() {
        this.name = this.getClass().getSimpleName();
        int n = this.name.indexOf("Filter");
        if (n > 0 && n < this.name.length() - 1) {
            this.name = this.name.substring(0, n);
        }
        this.enabledAction = new AbstractAction(MediaRes.getString("Filter.MenuItem.Enabled")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter.this.setEnabled(Filter.this.enabledItem.isSelected());
                Filter.this.refresh();
            }
        };
        this.enabledItem = new JCheckBoxMenuItem(this.enabledAction);
        this.enabledItem.setSelected(this.isEnabled());
        this.propertiesItem = new JMenuItem(MediaRes.getString("Filter.MenuItem.Properties"));
        this.propertiesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = Filter.this.getInspector();
                if (jDialog != null) {
                    jDialog.setVisible(true);
                }
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = Filter.this.getInspector();
                if (jDialog != null) {
                    jDialog.setVisible(false);
                }
            }
        });
        this.ableButton = new JButton();
        this.ableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter.this.enabledItem.setSelected(!Filter.this.enabledItem.isSelected());
                Filter.this.enabledAction.actionPerformed(null);
            }
        });
        this.clearButton = new JButton();
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter.this.clear();
            }
        });
    }

    public abstract BufferedImage getFilteredImage(BufferedImage var1);

    public abstract JDialog getInspector();

    public void clear() {
    }

    public void setVideoPanel(VideoPanel videoPanel) {
        this.vidPanel = videoPanel;
    }

    public void refresh() {
        this.enabledItem.setText(MediaRes.getString("Filter.MenuItem.Enabled"));
        this.propertiesItem.setText(MediaRes.getString("Filter.MenuItem.Properties"));
        this.closeButton.setText(MediaRes.getString("Filter.Button.Close"));
        this.ableButton.setText(this.isEnabled() ? MediaRes.getString("Filter.Button.Disable") : MediaRes.getString("Filter.Button.Enable"));
        this.clearButton.setText(MediaRes.getString("Filter.Button.Clear"));
        this.clearButton.setEnabled(this.isEnabled());
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        this.support.firePropertyChange("enabled", null, new Boolean(bl));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public JMenu getMenu(Video video2) {
        JMenu jMenu = new JMenu(MediaRes.getString("VideoFilter." + this.name));
        if (this.hasInspector) {
            jMenu.add(this.propertiesItem);
            jMenu.addSeparator();
        }
        jMenu.add(this.enabledItem);
        if (video2 != null) {
            jMenu.addSeparator();
            this.deleteItem = new JMenuItem(MediaRes.getString("Filter.MenuItem.Delete"));
            final FilterStack filterStack = video2.getFilterStack();
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    filterStack.removeFilter(Filter.this);
                }
            });
            jMenu.add(this.deleteItem);
        }
        return jMenu;
    }
}

