/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.tools.FontSizer;

public abstract class AbstractAxes
implements DrawableAxes {
    protected int defaultLeftGutter = 45;
    protected int defaultTopGutter = 25;
    protected int defaultRightGutter = 25;
    protected int defaultBottomGutter = 45;
    protected boolean visible = true;
    protected Font titleFont = new Font("Dialog", 1, 14);
    protected Font labelFont = new Font("SansSerif", 0, 9);
    protected Font superscriptFont = new Font("SansSerif", 0, 9);
    protected DecimalFormat labelFormat = new DecimalFormat("0.0");
    protected Color gridcolor = Color.lightGray;
    protected Color interiorColor = Color.white;
    protected DrawableTextLine titleLine = new DrawableTextLine("", 0.0, 0.0);
    protected DrawingPanel drawingPanel;

    public AbstractAxes(DrawingPanel drawingPanel) {
        this.drawingPanel = drawingPanel;
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), drawingPanel);
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractAxes.this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), AbstractAxes.this.drawingPanel);
            }
        });
    }

    public void setDefaultGutters(int n, int n2, int n3, int n4) {
        this.defaultLeftGutter = n;
        this.defaultTopGutter = n2;
        this.defaultRightGutter = n3;
        this.defaultBottomGutter = n4;
    }

    public void resetPanelGutters() {
        this.drawingPanel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    @Override
    public Color getInteriorBackground() {
        return this.interiorColor;
    }

    @Override
    public void resizeFonts(double d, DrawingPanel drawingPanel) {
        this.labelFont = FontSizer.getResizedFont(this.labelFont, d);
        this.superscriptFont = FontSizer.getResizedFont(this.superscriptFont, d);
        this.titleFont = FontSizer.getResizedFont(this.titleFont, d);
        this.titleLine.setFont(this.titleFont);
    }

    @Override
    public String getTitle() {
        return this.titleLine.getText();
    }

    @Override
    public void setTitle(String string, String string2) {
        this.titleLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(string2));
    }
}

