/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeNode;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTreePanel
extends JPanel {
    protected JLabel label;
    protected JTextField input;
    protected JTextPane xmlPane;
    protected JTree tree;
    protected JScrollPane treeScroller = new JScrollPane();
    protected Icon valueIcon;
    protected Icon inspectIcon;
    protected Icon inspectFolderIcon;
    protected Icon folderIcon;
    protected XMLControl control;
    protected XMLProperty property;
    protected boolean editable;
    protected JPopupMenu popup;
    int maxStringLength = 24;

    public XMLTreePanel(XMLControl xMLControl) {
        this(xMLControl, true);
    }

    public XMLTreePanel(XMLControl xMLControl, boolean bl) {
        super(new BorderLayout());
        this.control = xMLControl;
        this.editable = bl;
        this.createGUI();
    }

    public void refresh() {
        XMLTreeNode xMLTreeNode = this.createTree(this.control);
        this.displayProperty(xMLTreeNode, this.editable);
    }

    public XMLControl getControl() {
        return this.control;
    }

    public XMLTreeNode setSelectedNode(String string) {
        XMLTreeNode xMLTreeNode = (XMLTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = xMLTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            XMLTreeNode xMLTreeNode2 = (XMLTreeNode)enumeration.nextElement();
            XMLProperty xMLProperty = xMLTreeNode2.getProperty();
            if (!xMLProperty.getPropertyName().equals(string)) continue;
            TreePath treePath = new TreePath(xMLTreeNode2.getPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
            this.showInspector(xMLTreeNode2);
            return xMLTreeNode2;
        }
        return null;
    }

    protected void displayProperty(XMLTreeNode xMLTreeNode, boolean bl) {
        Object object;
        this.input.setVisible(false);
        XMLProperty xMLProperty = xMLTreeNode.getProperty();
        this.label.setText(String.valueOf(xMLProperty.getPropertyType()) + " " + xMLProperty.getPropertyName());
        if (!xMLProperty.getPropertyContent().isEmpty() && (object = xMLProperty.getPropertyContent().get(0)) instanceof String) {
            this.property = xMLProperty;
            String string = (String)object;
            if (string.indexOf("<![CDATA[") != -1) {
                string = string.substring(string.indexOf("<![CDATA[") + "<![CDATA[".length(), string.length() - "]]>".length());
            }
            this.input.setText(string);
            this.input.setEditable(bl);
            this.input.setVisible(true);
        }
        object = xMLProperty.toString();
        this.xmlPane.setText(this.getDisplay((String)object));
        this.xmlPane.setCaretPosition(0);
    }

    protected String getDisplay(String string) {
        String string2 = "";
        String string3 = "name=\"array\" type=\"string\">";
        String string4 = "</property>";
        int n = string.indexOf(string3);
        while (n > 0) {
            string2 = String.valueOf(string2) + string.substring(0, n += string3.length());
            string = string.substring(n);
            n = string.indexOf(string4);
            String string5 = string.substring(0, n);
            string = string.substring(n, string.length());
            if (string5.length() > this.maxStringLength) {
                string5 = String.valueOf(string5.substring(0, this.maxStringLength - 3)) + "...";
            }
            string2 = String.valueOf(string2) + string5;
            n = string.indexOf(string3);
        }
        string2 = String.valueOf(string2) + string;
        return string2;
    }

    protected void createGUI() {
        String string = "/org/opensourcephysics/resources/controls/images/inspect.gif";
        this.inspectIcon = new ImageIcon(XMLTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/controls/images/value.gif";
        this.valueIcon = new ImageIcon(XMLTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/controls/images/folder.gif";
        this.folderIcon = new ImageIcon(XMLTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/controls/images/inspectfolder.gif";
        this.inspectFolderIcon = new ImageIcon(XMLTreePanel.class.getResource(string));
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(ControlsRes.getString("XMLTreePanel.Popup.MenuItem.Inspect"));
        this.popup.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTreeNode xMLTreeNode = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (xMLTreeNode != null) {
                    XMLTreePanel.this.showInspector(xMLTreeNode);
                }
            }
        });
        XMLTreeNode xMLTreeNode = this.createTree(this.control);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.label = new JLabel();
        jToolBar.add(this.label);
        this.input = new JTextField(20);
        this.input.setVisible(false);
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTreePanel.this.property.setValue(XMLTreePanel.this.input.getText());
                Object object = XMLTreePanel.this.control.loadObject(null);
                if (object instanceof Component) {
                    ((Component)object).repaint();
                }
                XMLTreePanel.this.input.setText((String)XMLTreePanel.this.property.getPropertyContent().get(0));
                XMLTreePanel.this.input.selectAll();
                XMLTreeNode xMLTreeNode = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (xMLTreeNode != null) {
                    XMLTreePanel.this.displayProperty(xMLTreeNode, XMLTreePanel.this.editable);
                }
            }
        });
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!XMLTreePanel.this.editable) {
                    return;
                }
                JComponent jComponent = (JComponent)keyEvent.getSource();
                if (keyEvent.getKeyCode() == 10) {
                    jComponent.setBackground(Color.white);
                } else {
                    jComponent.setBackground(Color.yellow);
                }
            }
        });
        this.input.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.setBackground(Color.white);
            }
        });
        jToolBar.add(this.input);
        this.xmlPane = new JTextPane(){

            @Override
            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.xmlPane.setPreferredSize(new Dimension(360, 200));
        this.xmlPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.xmlPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JSplitPane jSplitPane = new JSplitPane(1, this.treeScroller, jPanel);
        this.add((Component)jSplitPane, "Center");
        this.treeScroller.setPreferredSize(new Dimension(140, 200));
        this.displayProperty(xMLTreeNode, this.editable);
    }

    private XMLTreeNode createTree(XMLControl xMLControl) {
        XMLTreeNode xMLTreeNode = new XMLTreeNode(xMLControl);
        this.tree = new JTree(xMLTreeNode);
        this.tree.setCellRenderer(new XMLRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                XMLTreeNode xMLTreeNode = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                if (xMLTreeNode != null) {
                    XMLTreePanel.this.displayProperty(xMLTreeNode, XMLTreePanel.this.editable);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    TreePath treePath = XMLTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    XMLTreePanel.this.tree.setSelectionPath(treePath);
                    XMLTreeNode xMLTreeNode = (XMLTreeNode)XMLTreePanel.this.tree.getLastSelectedPathComponent();
                    if (xMLTreeNode.isInspectable()) {
                        XMLTreePanel.this.popup.show(XMLTreePanel.this.tree, mouseEvent.getX(), mouseEvent.getY() + 8);
                    }
                }
            }
        });
        this.treeScroller.setViewportView(this.tree);
        return xMLTreeNode;
    }

    private void showInspector(XMLTreeNode xMLTreeNode) {
        XMLProperty xMLProperty;
        ArrayInspector arrayInspector;
        if (xMLTreeNode == null) {
            return;
        }
        if (xMLTreeNode.getProperty().getPropertyType().equals("array") && (arrayInspector = ArrayInspector.getInspector(xMLProperty = xMLTreeNode.getProperty())) != null) {
            String string = xMLProperty.getPropertyName();
            XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
            while (!(xMLProperty2 instanceof XMLControl)) {
                string = xMLProperty2.getPropertyName();
                xMLProperty = xMLProperty2;
                xMLProperty2 = xMLProperty2.getParentProperty();
            }
            final XMLControl xMLControl = (XMLControl)xMLProperty2;
            final String string2 = string;
            final Object object = arrayInspector.getArray();
            final XMLTreeNode xMLTreeNode2 = (XMLTreeNode)xMLTreeNode.getParent();
            arrayInspector.setEditable(this.editable);
            arrayInspector.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("cell")) {
                        xMLControl.setValue(string2, object);
                        XMLTreePanel.this.control.loadObject(null);
                        block0: for (XMLProperty xMLProperty : xMLControl.getPropertyContent()) {
                            if (!xMLProperty.getPropertyName().equals(string2)) continue;
                            int n = 0;
                            while (n < xMLTreeNode2.getChildCount()) {
                                XMLTreeNode xMLTreeNode = (XMLTreeNode)xMLTreeNode2.getChildAt(n);
                                if (xMLTreeNode.getProperty().getPropertyName().equals(string2)) {
                                    XMLTreeNode xMLTreeNode22 = new XMLTreeNode(xMLProperty);
                                    TreeModel treeModel = XMLTreePanel.this.tree.getModel();
                                    if (!(treeModel instanceof DefaultTreeModel)) break block0;
                                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModel;
                                    defaultTreeModel.removeNodeFromParent(xMLTreeNode);
                                    defaultTreeModel.insertNodeInto(xMLTreeNode22, xMLTreeNode2, n);
                                    TreePath treePath = new TreePath(xMLTreeNode22.getPath());
                                    XMLTreePanel.this.tree.setSelectionPath(treePath);
                                    break block0;
                                }
                                ++n;
                            }
                            break block0;
                        }
                    }
                }
            });
            Container container = this.getTopLevelAncestor();
            Point point = container.getLocationOnScreen();
            arrayInspector.setLocation(point.x + 30, point.y + 30);
            arrayInspector.setVisible(true);
        }
    }

    private class XMLRenderer
    extends DefaultTreeCellRenderer {
        private XMLRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            XMLTreeNode xMLTreeNode = (XMLTreeNode)object;
            if (xMLTreeNode.isLeaf()) {
                if (xMLTreeNode.isInspectable()) {
                    this.setIcon(XMLTreePanel.this.inspectIcon);
                } else {
                    this.setIcon(XMLTreePanel.this.valueIcon);
                }
            } else if (xMLTreeNode.isInspectable()) {
                this.setIcon(XMLTreePanel.this.inspectFolderIcon);
            } else {
                this.setIcon(XMLTreePanel.this.folderIcon);
            }
            return this;
        }
    }
}

